<?php
namespace Andriu\Component\Excelimport\Administrator\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Filter\OutputFilter;
use Joomla\CMS\Table\Table;

use Joomla\CMS\Table\Content; 
use Joomla\CMS\Component\ComponentHelper;      
use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Text;
use Joomla\Registry\Registry;
use Joomla\Component\Content\Administrator\Table\ArticleTable;





class ImportController extends BaseController {
	
	
     public function upload()   {
		 
		 $model = $this->getModel('Import');
        $app = Factory::getApplication();
        $input = $app->input;
        $user = Factory::getUser();
        $db = Factory::getDbo();
        $date = Factory::getDate();
        $lang = $input->getCmd('lang', '*');
        $categoryId = $input->getInt('category_id');
		$title_letter = strtoupper(trim($input->getString('title_letter')));
        $image_letter = strtoupper(trim($input->getString('image_letter')));
        $text_letter  = strtoupper(trim($input->getString('text_letter')));
		$description  = strtoupper(trim($input->getString('description')));
		
		$pattern_pola = '/^[A-Za-z]?$/'; // Регулярка: лише одна латинська літера або пуста строчка
		

        $file = $input->files->get('excel_file');
        if (empty($file) || $file['error']) {
			$this->fail(Text::_('COM_EXCELIMPORT_ERROR_FILE_UPLOAD'));
            return;
        }
// Дозволені MIME типи та розширення
$allowedMime = [
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', // .xlsx
    'application/vnd.ms-excel', // .xls
];
$allowedExt = ['xls', 'xlsx'];

// Перевірка MIME типу
if (!in_array($file['type'], $allowedMime)) {
	$this->fail(Text::_('COM_EXCELIMPORT_ERROR_BAD_FILETYPE'));
     return;
}

// Перевірка розширення
$ext = strtolower(File::getExt($file['name']));
if (!in_array($ext, $allowedExt)) {
	$this->fail(Text::_('COM_EXCELIMPORT_ERROR_BAD_FILETYPE'));
    return;
}
        // Зберігаємо у тимчасовий каталог Joomla
        $tmpPath = \JPATH_ROOT . '/tmp';
        if (!is_dir($tmpPath)) {
            mkdir($tmpPath, 0755, true);
        }
        $dest = $tmpPath . '/' . uniqid('excel_') . '_' . basename($file['name']);
        if (!move_uploaded_file($file['tmp_name'], $dest)) {
				$this->fail(Text::_('COM_EXCELIMPORT_ERROR_TMP_SAVE'));
            return;
        }

        // Завантажуємо PhpSpreadsheet
        $vendor =  dirname(__DIR__, 2) . '/vendor/autoload.php';  
        if (!file_exists($vendor)) {
            // пробуємо в корні сайта знайти
           $vendor = \JPATH_ROOT . '/vendor/autoload.php';

        }
        if (!file_exists($vendor)) {
            // видаляємо тимчасовий файл
            @unlink($dest);
		
				$this->fail(Text::_('COM_EXCELIMPORT_ERROR_MISSING_LIBRARY'));
            return;
        }
        require_once $vendor;

        try {
            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($dest);
        } catch (\Exception $e) {
            @unlink($dest);
		
			$this->fail(Text::sprintf( 'COM_EXCELIMPORT_ERROR_EXCEL_OPEN',  $e->getMessage()));
            return;
        }

       $worksheet = $spreadsheet->getActiveSheet();

        $imported = 0;// обща кількість  статей 
		
        $updated = 0; // кількість оновлених статей
        
		$new = 0; // кількість нових  статей
	//$newCats = 0; // кількість оновлених категорій
	
    $skipped = 0; // кількість пропущених рядків
    $errors = []; // масив для логів помилок
	
    // --- Створюємо один інстанс таблиці Content для клонування ---
    $articleTable = Table::getInstance('Content');
	// --- Підготовка дефолтних атрибутів один раз перед циклом ---
$attribsDefaults = [];
$formPath = JPATH_ADMINISTRATOR . '/components/com_content/forms/article.xml';
if (is_file($formPath)) {
    try {
        $form = Form::getInstance('com_content.article', $formPath);
        foreach ($form->getFieldset('attribs') as $field) {
            $attribsDefaults[$field->fieldname] = $field->value ?? $field->getAttribute('default', '');
        }
    } catch (\Exception $e) {
        $attribsDefaults = [];
    }
}
$attribsJSON = json_encode($attribsDefaults, JSON_UNESCAPED_UNICODE);
	

	// Імпортуємо рядки (починаємо з 2-го - припускається заголовок)
  foreach ($worksheet->getRowIterator(2) as $rowObj) {

    $cellIterator = $rowObj->getCellIterator();
    $cellIterator->setIterateOnlyExistingCells(false); // <-- важливо!

    $row = [];

    foreach ($cellIterator as $cell) {

        // Колонка
        $col = $cell->getColumn();

        // 1) Отримуємо ОБЧИСЛЕНЕ значення формули
        $value = $cell->getCalculatedValue();

        // 2) Хочеш ще й текст самої формули?
        // $formula = $cell->getValue(); // повертає текст "=A1+B1"

        $row[$col] = $value;
    }
    // Перевірка, чи рядок порожній
    $isEmpty = true;
    foreach ($row as $cell) {
        if (trim((string)$cell) !== '') {
            $isEmpty = false;
            break;
        }
    }

    if ($isEmpty) {
        $skipped++;
        $errors[]  = Text::sprintf('COM_EXCELIMPORT_ROW_EMPTY', $i);
        continue;
    }
 
	
	
	
	if ($categoryId <= 0) {
		 $this->fail(Text::_('COM_EXCELIMPORT_ERROR_NO_CATEGORY'));
        return false;
    }
else {
	$catid =  $categoryId; 
}
	$title = $this->getColumnValue($row, $title_letter);
if ($title === null) {
    $this->fail(Text::_('COM_EXCELIMPORT_ERROR_TITLE_LETTER'));
    continue; // пропускаємо цей рядок
} else { 
 if ($title === '') {
        $skipped++;
        $errors[] = Text::sprintf('COM_EXCELIMPORT_MISSING_ARTICLE_TITLE', $i);
        continue;
    }
}

$image = $this->getColumnValue($row, $image_letter);
if ($image === null) {
    $this->fail(Text::_('COM_EXCELIMPORT_ERROR_IMAGE_LETTER'));
    continue;
}

$content = $this->getColumnValue($row, $text_letter);
if ($content === null) {
    $this->fail(Text::_('COM_EXCELIMPORT_ERROR_TEXT_LETTER'));
    continue;
}
	
		
$alias = OutputFilter::stringURLSafe(trim($title));


$baseAlias = $alias;
$suffix = 1;
$aliasTable = clone $articleTable;
while ($aliasTable->load(['alias' => $alias, 'catid' => $catid])) {
    // Додаємо суфікс
    $alias = $baseAlias . '-' . $suffix;
    $suffix++;
}

$existingId = $model->getExistingArticleId($title, $catid);
        // --- Завантажуємо або створюємо ---
         $article = clone $articleTable;
        if ($existingId) {
            $article->load($existingId);
        } else {
            $article->id = 0;
        }

// Підготовка даних статті
$data = [
    'title'   => $title,
    'alias'   => $alias ?: OutputFilter::stringURLSafe($title),
    'introtext' => mb_substr(strip_tags($content), 0, 200),
    'fulltext'  => $content,
    'catid'     => $catid,
    'state'     => 1,           // ✅ Опубліковано
    'access'    => 1,
    'language'  => $lang,
    'created'   => $date->toSql(),
    'created_by'=> $user->id,
    'created_by_alias' => $user->name, 
	'images'   => json_encode([
                'image_intro' => $image ?: '',
                'float_intro' => '',
                'image_fulltext' => $image ?: '',
                'float_fulltext' => ''
            ], JSON_UNESCAPED_UNICODE),
  'urls' => json_encode([
            'urla' => '', 'urlatext' => '', 'targeta' => '',
            'urlb' => '', 'urlbtext' => '', 'targetb' => '',
            'urlc' => '', 'urlctext' => '', 'targetc' => ''
        ], JSON_UNESCAPED_UNICODE),
        // --- Присвоюємо готові атрибути ---
        'attribs' => $attribsJSON	
];




// Bind дані у ArticleTable
$article->bind($data);

// Примусово переконуємось, що state = 1
$article->state = 1;

// --- Генерація SEO-метаданих ---
  if ($description === '' ) {
	  
$description_seo = $content;

  }   else {	
  $description_seo = isset($row[$description]) ? trim($row[$description]) : '';
}

$article->metadesc = $this->prepareDescription($description_seo);	
$article->metakey  = $this->metaKeywords($content);

$metadataArray = [
    'robots' => 'index, follow',
    'author' => $user->name,
    'rights' => '© ' . date('Y') . ' ' . $user->name,
    'xreference' => '',
	 'description' => $article->metadesc,
    'keywords' => $article->metakey
];
// Створюємо Registry
$reg = new Registry();
$reg->loadArray($metadataArray);

// Записуємо у статтю
$article->metadata = (string) $reg;

	
// Виконуємо перевірку
if (!$article->check()) {
        $skipped++;
        $errors[] = Text::sprintf('COM_EXCELIMPORT_VALIDATION_ERROR', $i, $article->getError());
        continue;
    }
 
if (!$article->store()) {
     $skipped++;
      $errors[] = Text::sprintf('COM_EXCELIMPORT_NOT_SAVED', $i, $article->getError());
        continue;
}

		if ($existingId) { $updated++; } 
		else { $new++; }
// Після успішного збереження статті
if ($article->id)
{
   $model->workflowTable($article->id);
  
}

// ДОДАТКОВІ ПОЛЯ
$names = $model->getAllCustomFieldNames();
//$names = ['price', 'vid', 'availability'];
if (!empty($names)) {
$fieldMap = $model->CustomFieldsID($names);

// Отримуємо відповідність "поле → літера стовпця" з POST

$userMap = $input->post->get('fields', [], 'array');

// Перевірка правильності введених стовпців

foreach ($userMap as $fieldName => $colLetter) {
    $colLetter =  strtoupper(trim($colLetter));
    if (!preg_match($pattern_pola, $colLetter)) {
		$this->fail(Text::sprintf( 'COM_EXCELIMPORT_FIELD_ONE_LETTER', htmlspecialchars($fieldName)));
		return false;
    }
}
// Формуємо масив значень з Excel для кожного поля
$fields = [];

foreach ($names as $name) {
    // Якщо користувач не вибрав колонку для цього поля — пропускаємо
    if (empty($userMap[$name])) {
        continue;
    }

    $col = strtoupper(trim($userMap[$name])); // літера колонки (наприклад 'D')

    // Якщо в рядку Excel є така колонка — беремо її значення
    if (isset($row[$col])) {
        $fields[$name] = trim((string)$row[$col]);
    }
}

 if (!empty($fields)) {
$model->saveCustomFields($article->id, $fields, $fieldMap);				
 }
		}
            $imported++;
        }
		
		// Переклад сортування в межах категорії
		
if ($new > 0 || $updated > 0) {
    $table = Table::getInstance('Content');
    $table->reorder('catid = ' . (int)$catid);
}

        // Видаляємо тимчасовий файл
      @unlink($dest);

        // Повідомлення
      if ($imported > 0) {
	       $app->enqueueMessage( Text::sprintf('COM_EXCELIMPORT_IMPORT_SUCCESS', $new, $updated,  $imported), 'message');
		  
	  }
	if ($skipped > 0) {
    // Повідомлення про загальну кількість пропущених рядків
    $app->enqueueMessage(
        Text::sprintf('COM_EXCELIMPORT_IMPORT_SKIPPED', $skipped),
        'warning'
    );

    // Беремо максимум 10 причин
    $shortList = array_slice($errors, 0, 10);

    // Формуємо короткий список деталей
    $details = implode("\n", $shortList);

    // Якщо всього пропущено більше 10 рядків, додаємо повідомлення про інші опущено
    if ($skipped > count($shortList)) {
        $details .= "\n" . Text::_('COM_EXCELIMPORT_OTHERS_SKIPPED');
    }

    // Виводимо повідомлення з деталями
    $app->enqueueMessage(
        Text::sprintf('COM_EXCELIMPORT_IMPORT_DETAILS', $details),
        'notice'
    );
}

      $app->setUserState('com_excelimport.formdata', $input->post->getArray());
      $this->setRedirect('index.php?option=com_excelimport&view=import');
		
    }
	

private function metaKeywords($content) {
    if (!empty(trim($content))) {

        // Прибираємо HTML
        $plainText = strip_tags($content);

        // Keywords — топ-5 найчастіших унікальних слів
        $words = mb_strtolower($plainText);
        $words = preg_replace('/[^a-zа-яіїєґ0-9\s]/iu', '', $words);
        $wordArray = preg_split('/\s+/', $words);

        // Отримуємо стоп-слова з мовного файлу
        $stopWordsString = Text::_('COM_EXCELIMPORT_STOPWORDS');
        $stopWords = array_map('trim', explode(',', $stopWordsString));

        $filtered = array_filter($wordArray, fn($w) => mb_strlen($w) > 3 && !in_array($w, $stopWords));
        $freq = array_count_values($filtered);
        arsort($freq);

        $topKeywords = array_slice(array_keys($freq), 0, 5);
        return implode(', ', $topKeywords);

    } else {
        return '';
    }
}



	/**
 * Генерує текст для Description з основного тексту статті
 *
 * @param string $content Текст статті
 * @param int $maxLength Максимальна довжина Description (символів)
 * @return string
 */
private function prepareDescription($content)
{
	if (!empty(trim($content))) {
	$maxLength = 160;
    // 1. Видаляємо HTML-теги
    $text = strip_tags($content);

    // 2. Видаляємо зайві пробіли, табуляції, перенос рядків
    $text = preg_replace('/\s+/', ' ', $text);
    $text = trim($text);

    // 3. Обрізаємо до потрібної довжини без обриву слова
    if (mb_strlen($text) > $maxLength) {
        $text = mb_substr($text, 0, $maxLength);
        // обрізаємо до останнього пробілу
        $lastSpace = mb_strrpos($text, ' ');
        if ($lastSpace !== false) {
            $text = mb_substr($text, 0, $lastSpace);
        }
        $text .= '...';
    }

    return $text;
}
	else {  return '';	}
}
private function getColumnValue(array $row, string $letter) {
    
// Регулярка: лише одна латинська літера
        $pattern = '/^[A-Za-z]{1}$/';
    if ($letter === '' || !preg_match($pattern, $letter)) {
        return null; // сигнал про помилку
    }

    return isset($row[$letter]) ? trim($row[$letter]) : '';
	
}

private function fail(string $message)
{
    $app = Factory::getApplication();
    $input = $app->input;
    $app->enqueueMessage($message, 'error');
    $app->setUserState('com_excelimport.formdata', $input->post->getArray());
    $this->setRedirect('index.php?option=com_excelimport&view=import');
}	
}