<?php


namespace Andriu\Component\Excelimport\Administrator\Model;


use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\Database\DatabaseQuery;
use Joomla\Filter\OutputFilter;
use Joomla\CMS\Table\Table;
use Joomla\Registry\Registry;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Fields\FieldsHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Private Message model.
 *
 * @since  1.6
 */
class  CategoryModel extends BaseDatabaseModel {
	
public function getExistingCategoryId(string $title, int $parentId): ?int
{
    $db = $this->getDatabase();

    $query = $db->getQuery(true)
        ->select($db->quoteName('id'))
        ->from($db->quoteName('#__categories'))
        ->where($db->quoteName('title') . ' = ' . $db->quote($title))
        ->where($db->quoteName('parent_id') . ' = ' . (int) $parentId)
        ->where($db->quoteName('extension') . ' = ' . $db->quote('com_content')) // тільки категорії контенту
        ->setLimit(1);

    return $db->setQuery($query)->loadResult() ?: null;
}


	
	

public function CustomFieldsCategoryID(array $names): array
{
    if (empty($names)) {
        return [];
    }

    $db = $this->getDbo();

    // Контексти для категорій
    $contexts = ['com_content.category', 'com_content.categories'];

    $fieldMap = [];

    foreach ($contexts as $context) {
        $quotedNames = implode(',', array_map(fn($n) => $db->quote($n), $names));

        $query = $db->getQuery(true)
            ->select($db->quoteName('id') . ', ' . $db->quoteName('name'))
            ->from($db->quoteName('#__fields'))
            ->where($db->quoteName('context') . ' = ' . $db->quote($context))
            ->where($db->quoteName('name') . ' IN (' . $quotedNames . ')');

        $db->setQuery($query);
        $results = $db->loadAssocList();

        foreach ($results as $row) {
            $fieldMap[$row['name']] = (int)$row['id'];
        }
    }

   

    return $fieldMap;
}



/**
     * Зберігає кастомні поля для категорії
     *
     * @param int $categoryId   ID категорії
     * @param array $fields     ['field_name' => 'value']
     * @param array $fieldMap   ['field_name' => field_id]
     * @return bool
     */
    public function saveCategoryFields(int $categoryId, array $fields, array $fieldMap): bool
  {
    $db = $this->getDbo();

    foreach ($fields as $fname => $fval) {
        // Якщо немає ID поля — пропускаємо
        if (empty($fieldMap[$fname])) {
            continue;
        }

        // Якщо значення не scalar — пропускаємо
        if (!is_scalar($fval)) {
            continue;
        }

        // Приводимо до рядка
        $value = trim((string)$fval);
        if ($value === '') {
            continue;
        }

        // Видаляємо старе значення (якщо було)
        $delete = $db->getQuery(true)
            ->delete($db->quoteName('#__fields_values'))
            ->where($db->quoteName('field_id') . ' = ' . (int)$fieldMap[$fname])
            ->where($db->quoteName('item_id') . ' = ' . (int)$categoryId);
        $db->setQuery($delete)->execute();

        // Додаємо нове значення
        $insert = $db->getQuery(true)
            ->insert($db->quoteName('#__fields_values'))
            ->columns([$db->quoteName('field_id'), $db->quoteName('item_id'), $db->quoteName('value')])
            ->values(
                (int)$fieldMap[$fname] . ', ' . (int)$categoryId . ', ' . $db->quote($value)
            );
        $db->setQuery($insert)->execute();
    }
	return true;
}

public function getAllCategoryCustomFieldNames(): array
{
    $db  = $this->getDbo();

    // Спробуємо стандартний контекст для категорій
    $contexts = ['com_content.category', 'com_content.categories'];

    $names = [];

    foreach ($contexts as $context) {
        $query = $db->getQuery(true)
            ->select($db->quoteName('name'))
            ->from($db->quoteName('#__fields'))
            ->where($db->quoteName('context') . ' = ' . $db->quote($context))
            ->where($db->quoteName('state') . ' = 1'); // тільки активні

        $db->setQuery($query);
        $result = $db->loadColumn();

        if (!empty($result)) {
            $names = array_merge($names, $result);
        }
    }

  

    return $names ?: [];
}



// додаткова функція яка працює з категоріями
public function workflowCategory(int $categoryId)
{
        $db  = $this->getDbo();
    $workflowTable = $db->quoteName('#__workflow_associations');

    // Перевіряємо, чи вже є зв’язок
    $query = $db->getQuery(true)
        ->select('COUNT(*)')
        ->from($workflowTable)
        ->where('item_id = ' . (int) $categoryId)
        ->where('extension = ' . $db->quote('com_content.category'));
    $db->setQuery($query);
    $exists = (int) $db->loadResult();

    if (!$exists)
    {
        // 🔍 Отримуємо ID стандартного етапу для категорій
        $query = $db->getQuery(true)
            ->select('ws.id')
            ->from($db->quoteName('#__workflow_stages', 'ws'))
            ->join('INNER', $db->quoteName('#__workflows', 'w') . ' ON w.id = ws.workflow_id')
            ->where('w.extension = ' . $db->quote('com_content.category'))
            ->where('ws.default = 1');
        $db->setQuery($query);
        $stageId = (int) $db->loadResult();

        // Якщо не знайдено — fallback
        if (!$stageId)
        {
            $query = $db->getQuery(true)
                ->select('id')
                ->from($db->quoteName('#__workflow_stages'))
                ->where('workflow_id = 1');
            $db->setQuery($query);
            $stageId = (int) $db->loadResult();
        }

        // ✅ Додаємо зв’язок у workflow_associations
        if ($stageId)
        {
            $insert = $db->getQuery(true)
                ->insert($workflowTable)
                ->columns(['item_id', 'stage_id', 'extension'])
                ->values(
                    (int)$categoryId . ', ' .
                    (int)$stageId . ', ' .
                    $db->quote('com_content.category')
                );
            $db->setQuery($insert)->execute();
        }
    }
}
// ФУНКЦІЇ ДЛЯ ВИВОДУ фОРМИ В АДМІНЦІ


public  function getLanguagesOptions(): array
{
  
	 $db = $this->getDbo();

    $query = $db->getQuery(true)
        ->select(['lang_code', 'title'])
        ->from($db->quoteName('#__languages'))
        ->where($db->quoteName('published') . ' = 1')
        ->order('title ASC');

    $db->setQuery($query);

    $languages = $db->loadAssocList();

    // Якщо таблиця порожня, повернемо дефолтні
    if (!$languages) {
        return [
           
            ['lang_code' => '*', 'title' => Text::_('COM_EXCELIMPORT_ALL_LANGUAGES') ]
        ];
    }

    return $languages;
}
  
  


	public function getCategoryCustomFields(): array
{
    
    // Отримуємо базу даних
$db = $this->getDbo();

    // Запитуємо всі додаткові поля
    $query = $db->getQuery(true)
        ->select(['id', 'name', 'label', 'type', 'description', 'context'])
        ->from('#__fields')
        ->where($db->quoteName('state') . ' = 1') // тільки активні
        ->where($db->quoteName('context') . ' = ' . $db->quote('com_content.categories')); // тільки для статей

    $db->setQuery($query);
    $fields = $db->loadAssocList();

    // Якщо треба значення для кожного поля (опціонально)
    foreach ($fields as &$field) {
        $query = $db->getQuery(true)
            ->select('value')
            ->from('#__fields_values')
            ->where('field_id = ' . (int) $field['id'])
            ->setLimit(1);

        $db->setQuery($query);
        $field['value'] = $db->loadResult() ?? '';
    }

    return $fields;
}	
	
   
   
}
