<?php

namespace Andriu\Component\Excelimport\Administrator\Model;


use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\Database\DatabaseQuery;
use Joomla\Filter\OutputFilter;
use Joomla\CMS\Table\Table;
use Joomla\Registry\Registry;
use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Private Message model.
 *
 * @since  1.6
 */
class  ImportModel extends BaseDatabaseModel {
   
    /**
     * Повертає ID існуючої статті, якщо така вже є (за title + catid)
     *
     * @param string $title  Заголовок статті
     * @param int    $catid  ID категорії
     * @return int|null      ID статті або null, якщо не знайдено
     */
    public function getExistingArticleId(string $title, int $catid): ?int
    {
        $db = $this->getDbo();

        $query = $db->getQuery(true)
            ->select($db->quoteName('id'))
            ->from($db->quoteName('#__content'))
            ->where($db->quoteName('title') . ' = ' . $db->quote($title))
            ->where($db->quoteName('catid') . ' = ' . (int) $catid);

        $db->setQuery($query);
        $result = $db->loadResult();

        return $result ? (int)$result : null;
    }
	
	
	

 public  function workflowTable(int $articleid) { 
	
	 $db = $this->getDbo();
	 // Отримуємо таблицю workflow_associations
    $workflowTable = $db->quoteName('#__workflow_associations');

    // Перевіряємо, чи вже є зв’язок
    $query = $db->getQuery(true)
        ->select('COUNT(*)')
        ->from($workflowTable)
        ->where('item_id = ' . (int) $articleid)
        ->where('extension = ' . $db->quote('com_content.article'));

    $db->setQuery($query);
    $exists = (int) $db->loadResult();

    if (!$exists)
    {
        // 🔍 Дізнаємося ID стандартного етапу “Опубліковано”
        $query = $db->getQuery(true)
            ->select('ws.id')
            ->from($db->quoteName('#__workflow_stages', 'ws'))
            ->join('INNER', $db->quoteName('#__workflows', 'w') . ' ON w.id = ws.workflow_id')
            ->where('w.extension = ' . $db->quote('com_content'))
            ->where('ws.default = 1'); // default stage
        $db->setQuery($query);
        $stageId = (int) $db->loadResult();

        // Якщо не знайшло — fallback: спробуємо взяти перший етап
        if (!$stageId)
        {
            $query = $db->getQuery(true)
                ->select('id')
                ->from($db->quoteName('#__workflow_stages'))
                ->where('workflow_id = 1');
            $db->setQuery($query);
            $stageId = (int) $db->loadResult();
        }

        // ✅ Додаємо зв’язок у workflow_associations
        if ($stageId)
        {
            $insert = $db->getQuery(true)
                ->insert($workflowTable)
                ->columns(['item_id', 'stage_id', 'extension'])
                ->values((int) $articleid . ', ' . (int) $stageId . ', ' . $db->quote('com_content.article'));
            $db->setQuery($insert)->execute();
        }
    }
	
	}
	
 public function CustomFieldsID( array $names )  {
	    $db = $this->getDbo();
$query = $db->getQuery(true)
    ->select($db->quoteName(['id', 'name']))
    ->from($db->quoteName('#__fields'))
    ->where($db->quoteName('context') . ' = ' . $db->quote('com_content.article'))
    ->where($db->quoteName('name') . ' IN (' . implode(',', array_map(fn($n) => $db->quote($n), $names)) . ')');

$db->setQuery($query);
$results = $db->loadAssocList();

$fieldMap = [];
foreach ($results as $row) {
    $fieldMap[$row['name']] = (int)$row['id'];
}
 return $fieldMap;
 
}  
   
public  function saveCustomFields(int $articleId, array $fields, array $fieldMap)
{
    $db = $this->getDbo();

    foreach ($fields as $fname => $fval) {
        // Якщо немає ID поля — пропускаємо
        if (empty($fieldMap[$fname])) {
            continue;
        }

        // Якщо значення не scalar — пропускаємо
        if (!is_scalar($fval)) {
            continue;
        }

        // Приводимо до рядка
        $value = trim((string) $fval);
        if ($value === '') {
            continue;
        }

        // Видаляємо старе значення (якщо було)
        $delete = $db->getQuery(true)
            ->delete($db->quoteName('#__fields_values'))
            ->where($db->quoteName('field_id') . ' = ' . (int)$fieldMap[$fname])
            ->where($db->quoteName('item_id') . ' = ' . (int)$articleId);
        $db->setQuery($delete)->execute();

        // Додаємо нове значення
        $insert = $db->getQuery(true)
            ->insert($db->quoteName('#__fields_values'))
            ->columns([$db->quoteName('field_id'), $db->quoteName('item_id'), $db->quoteName('value')])
            ->values(
                (int)$fieldMap[$fname] . ', ' . (int)$articleId . ', ' . $db->quote($value)
            );
        $db->setQuery($insert)->execute();
    }
}


public function getAllCustomFieldNames(): array
{
    $db  = $this->getDbo();
    $query = $db->getQuery(true)
        ->select($db->quoteName('name'))
        ->from($db->quoteName('#__fields'))
        ->where($db->quoteName('context') . ' = ' . $db->quote('com_content.article'))
        ->where($db->quoteName('state') . ' = 1'); // тільки активні

    $db->setQuery($query);
    $names = $db->loadColumn();

    return $names ?: [];
}

// ФУНКЦІЇ ДЛЯ ВИВОДУ ФОРМИ В АДМІНЦІ


public  function getLanguagesOptions(): array
{
  
	 $db = $this->getDbo();

    $query = $db->getQuery(true)
        ->select(['lang_code', 'title'])
        ->from($db->quoteName('#__languages'))
        ->where($db->quoteName('published') . ' = 1')
        ->order('title ASC');

    $db->setQuery($query);

    $languages = $db->loadAssocList();

    // Якщо таблиця порожня, повернемо дефолтні
    if (!$languages) {
        return [
           
            ['lang_code' => '*', 'title' => Text::_('COM_EXCELIMPORT_ALL_LANGUAGES') ]
        ];
    }

    return $languages;
}
  
  
  public  function getCategoriesOptions() {
      
		
$db = $this->getDbo();

        $query = $db->getQuery(true)
            ->select('id, title')
            ->from($db->quoteName('#__categories'))
            ->where($db->quoteName('extension') . ' = ' . $db->quote('com_content'))
            ->where($db->quoteName('published') . ' = 1')
            ->order('title ASC');
        $db->setQuery($query);
        return $db->loadAssocList();
    }

public  function getCustomFields()
{
    // Отримуємо базу даних
$db = $this->getDbo();

    // Запитуємо всі додаткові поля
    $query = $db->getQuery(true)
        ->select(['id', 'name', 'label', 'type', 'description', 'context'])
        ->from('#__fields')
        ->where($db->quoteName('state') . ' = 1') // тільки активні
        ->where($db->quoteName('context') . ' = ' . $db->quote('com_content.article')); // тільки для статей

    $db->setQuery($query);
    $fields = $db->loadAssocList();

    // Якщо треба значення для кожного поля (опціонально)
    foreach ($fields as &$field) {
        $query = $db->getQuery(true)
            ->select('value')
            ->from('#__fields_values')
            ->where('field_id = ' . (int) $field['id'])
            ->setLimit(1);

        $db->setQuery($query);
        $field['value'] = $db->loadResult() ?? '';
    }

    return $fields;
}	
	
   
   
}
