<?php
defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

HTMLHelper::_('formbehavior.chosen', 'select');
$action = Route::_('index.php?option=com_excelimport&task=Selectcategory.choose');
// Отримуємо попередньо введені значення (якщо були)
$old = $this->formdata ?? [];
$selectedMode = $old['category_mode'] ?? 'existing';
?>
<div class="container mt-3">
    <h2><?php echo Text::_('COM_EXCELIMPORT_AUTO_ADD_CATEGORIES'); ?></h2>
	

    <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" class="form-validate">
      <div class="mb-3">
    <label for="lang" class="form-label"><?php echo Text::_('COM_EXCELIMPORT_FIELD_LANGUAGE'); ?></label>
    <select name="lang" id="lang" class="form-select" required>
	 <option value="*"><?php echo Text::_('COM_EXCELIMPORT_OPTION_SELECT_LANGUAGE'); ?></option>
        <?php foreach ($this->languages as $lang): ?>
            <option value="<?php echo htmlspecialchars($lang['lang_code']); ?>"
			  <?php echo (($old['lang'] ?? '') === $lang['lang_code']) ? 'selected' : ''; ?>>
                <?php echo htmlspecialchars($lang['title']); ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>
 


<fieldset class="border p-3 rounded mb-4">
  <legend class="fw-bold text-primary"> <?php echo Text::_('COM_EXCELIMPORT_EXCEL_COLUMNS'); ?></legend>
   <p class="text-muted small mb-3">
   <strong> 
   <?php echo Text::_('COM_EXCELIMPORT_ONE_LETTER_HINT'); ?></strong> 
  </p>
  <div class="mb-3">
  <label for="category" class="form-label">
    <i class="fa fa-folder "></i> <?php echo Text::_('COM_EXCELIMPORT_FIELD_CATEGORY'); ?>
  </label>
  <input type="text" name="category" id="category" maxlength="1" required pattern="[A-Za-z]" 
         class="form-control text-uppercase" value="<?php echo htmlspecialchars($old['category'] ?? ''); ?>" >
		 <div class="form-text"> <?php echo Text::_('COM_EXCELIMPORT_TIP_CATEGORY'); ?> </div>
</div>
  
<div class="mb-3">
  <label for="title_letter" class="form-label">
    <i class="fa fa-heading "></i> <?php echo Text::_('COM_EXCELIMPORT_FIELD_TITLE'); ?>
  </label>
  <input type="text" name="title_letter" id="title_letter" maxlength="1" required pattern="[A-Za-z]" 
         class="form-control text-uppercase" value="<?php echo htmlspecialchars($old['title_letter'] ?? ''); ?>" >
</div>

<div class="mb-3">
  <label for="image_letter" class="form-label">
    <i class="fa fa-image"></i> <?php echo Text::_('COM_EXCELIMPORT_FIELD_IMAGE'); ?>
  </label>
  <input type="text" name="image_letter" id="image_letter" required pattern="[A-Za-z]" maxlength="1"
         class="form-control text-uppercase" value="<?php echo htmlspecialchars($old['image_letter'] ?? ''); ?>" >
</div>

<div class="mb-3">
  <label for="text_letter" class="form-label">
    <i class="fa fa-align-left"></i> <?php echo Text::_('COM_EXCELIMPORT_FIELD_TEXT'); ?>
  </label>
  <input type="text" name="text_letter" id="text_letter" required pattern="[A-Za-z]" maxlength="1"
         class="form-control text-uppercase"  value="<?php echo htmlspecialchars($old['text_letter'] ?? ''); ?>" >
</div>
<div class="mb-3">
  <label for="text_letter" class="form-label">
    <i class="fa fa-align-left"></i> <?php echo Text::_('COM_EXCELIMPORT_FIELD_DESCRIPTION'); ?>
  </label>
  <input type="text" name="description" id="description"  pattern="[A-Za-z]" maxlength="1"
         class="form-control text-uppercase"  value="<?php echo htmlspecialchars($old['description'] ?? ''); ?>" >
</div>
</fieldset>
<?php if (!empty($this->fields)) { ?>
 <div class="mb-3">
<table class="table table-striped">
        <thead>
            <tr>
               <th><?php echo Text::_('COM_EXCELIMPORT_TABLE_NAME'); ?></th>
        <th><?php echo Text::_('COM_EXCELIMPORT_TABLE_LABEL'); ?></th>
        <th><?php echo Text::_('COM_EXCELIMPORT_TABLE_TYPE'); ?></th>
        <th><?php echo Text::_('COM_EXCELIMPORT_TABLE_HINT'); ?></th>
        <th><?php echo Text::_('COM_EXCELIMPORT_TABLE_EXCEL_COLUMN'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($this->fields as $field): ?>
                <tr>
                    <td><?php echo htmlspecialchars($field['name']); ?></td>
                    <td><?php echo htmlspecialchars($field['label']); ?></td>
                    <td><?php echo htmlspecialchars($field['type']); ?></td>
                    <td><?php echo htmlspecialchars($field['description']); ?></td>
                    <td>
                        <input type="text" maxlength="1"  pattern="[A-Za-z]" name="fields[<?php echo htmlspecialchars($field['name']); ?>]" value="<?php echo htmlspecialchars($old['fields'][$field['name']] ?? ''); ?>" >
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
  </div>
<?php } ?>
        <div class="mb-3">
            <label for="excel_file" class="form-label"> <?php echo Text::_('COM_EXCELIMPORT_FIELD_FILE'); ?></label>
            <input type="file" name="excel_file" id="excel_file" class="form-control" accept=".xlsx,.xls" required>
        </div>

        <button type="submit" class="btn btn-primary"> <?php echo Text::_('COM_EXCELIMPORT_BUTTON_IMPORT'); ?></button>
        <?php echo HTMLHelper::_('form.token'); ?>
    </form>
</div>
